# establish directories
# wd<-dirname(sys.frame(1)$ofile) # get dir of sourced R script and other dir
wd<-choose.dir()
mdir<-"MagTool Data" # dir name with MagTool data within dir with script
rdir<-"R Objects" # dir name for R objects within dir of R script

# _____________ EECs.df
# import EEC files into a single dataframe
# set file names for EEC files
c.file<-"chlorpyrifos_eec.csv"
d.file<-"diazinon_eec.csv"
m.file<-"malathion_eec.csv"
pro.file<-"prometryn_eec.csv"
bro_oct.file<-"bromoxynil_octanoate_eec.csv"
p.files<-c(c.file,d.file,m.file,pro.file,bro_oct.file)
p.names<-c("chlorpyrifos","diazinon","malathion","prometryn","bromoxynil octanoate")

# get dir name for EEC files assuming they are in the same dir
eec.dir<-file.path(wd,mdir) # or use dirname(file.choose())

for (i in 1:length(p.files)) {
  temp<-read.csv(file.path(eec.dir,p.files[i])) # read EEC csv
  temp<-cbind(p.names[i],temp) # prepend column with pesticide name
  names(temp)[1]<-"Pesticide" # rename first column that was created
  if (i == 1) EECs.df<-temp
  else EECs.df<-rbind(EECs.df,temp)
}
names(EECs.df)[6]<-"Crop"

# _________________  overlaps.ar, cdl.names
# import CDL data into a 3D array of overlaps (year,huc12,use with HUC12 and acres first)
# list of CDL files
cdl.files<-c("CDL_L48_2010.csv","CDL_L48_2011.csv","CDL_L48_2012.csv","CDL_L48_2013.csv","CDL_L48_2014.csv","CDL_L48_2015.csv")
# get dir name for CDL files assuming they are in the same dir
cdl.dir<-file.path(wd,mdir) # or use dirname(file.choose())

for (i in 1:length(cdl.files)) {
  temp<-read.csv(file.path(cdl.dir,cdl.files[i])) # read CDL csv
  temp<-temp[order(temp$HUC12),] # make sure to order overlap data by HUC12
  if (i == 1) overlaps.ar<-array(-1,dim=c(6,dim(as.matrix(temp)))) # create initial array
  overlaps.ar[i,,]<-as.matrix(temp)
}

cdl.names<-gsub("\\."," ",names(temp)) # list of use names with spaces

# _________________  huc_acres.df huc_convert.df
# create dataframe with huc12, acres, huc2

huc_convert.df<-read.csv(file.path(cdl.dir,"huc_convert.csv")) # get huc12 to huc2 conversion
huc_acres.df<-data.frame(overlaps.ar[1,,1:2])
names(huc_acres.df)<-c("HUC12","Acres")

# _________________  speciesHUC.df
# create dataframe with species id and comma-separated range huc12 list
speciesHUC.df<-read.csv(file.path(cdl.dir,"species_huc12.csv"),as.is=TRUE)

# _________________  habitatHUC.df
# create dataframe with species id and comma-separated critical habitat huc12 list
habitatHUC.df<-read.csv(file.path(cdl.dir,"critical_habitat_huc12.csv"),as.is=TRUE)

# _________________  species_info.df
# create dataframe from Species Summary with HUC, Bin, EntityID and Species
species_info.df<-read.delim(file.path(cdl.dir,"species_info.txt"),as.is=TRUE)

# _________________ save data objects to same dir
save(EECs.df,file=file.path(wd,rdir,"EECs.df"))
save(overlaps.ar,file=file.path(wd,rdir,"overlaps.ar"))
save(cdl.names,file=file.path(wd,rdir,"cdl.names"))
save(huc_convert.df,file=file.path(wd,rdir,"huc_convert.df"))
save(huc_acres.df,file=file.path(wd,rdir,"huc_acres.df"))
save(speciesHUC.df,file=file.path(wd,rdir,"speciesHUC.df"))
save(habitatHUC.df,file=file.path(wd,rdir,"habitatHUC.df"))
save(species_info.df,file=file.path(wd,rdir,"species_info.df"))